<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class VpnGateway extends \Google\Collection
{
  protected $collection_key = 'vpnInterfaces';
  public $creationTimestamp;
  public $description;
  public $id;
  public $kind;
  public $labelFingerprint;
  public $labels;
  public $name;
  public $network;
  public $region;
  public $selfLink;
  public $stackType;
  protected $vpnInterfacesType = VpnGatewayVpnGatewayInterface::class;
  protected $vpnInterfacesDataType = 'array';

  public function setCreationTimestamp($creationTimestamp)
  {
    $this->creationTimestamp = $creationTimestamp;
  }
  public function getCreationTimestamp()
  {
    return $this->creationTimestamp;
  }
  public function setDescription($description)
  {
    $this->description = $description;
  }
  public function getDescription()
  {
    return $this->description;
  }
  public function setId($id)
  {
    $this->id = $id;
  }
  public function getId()
  {
    return $this->id;
  }
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  public function getKind()
  {
    return $this->kind;
  }
  public function setLabelFingerprint($labelFingerprint)
  {
    $this->labelFingerprint = $labelFingerprint;
  }
  public function getLabelFingerprint()
  {
    return $this->labelFingerprint;
  }
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  public function getLabels()
  {
    return $this->labels;
  }
  public function setName($name)
  {
    $this->name = $name;
  }
  public function getName()
  {
    return $this->name;
  }
  public function setNetwork($network)
  {
    $this->network = $network;
  }
  public function getNetwork()
  {
    return $this->network;
  }
  public function setRegion($region)
  {
    $this->region = $region;
  }
  public function getRegion()
  {
    return $this->region;
  }
  public function setSelfLink($selfLink)
  {
    $this->selfLink = $selfLink;
  }
  public function getSelfLink()
  {
    return $this->selfLink;
  }
  public function setStackType($stackType)
  {
    $this->stackType = $stackType;
  }
  public function getStackType()
  {
    return $this->stackType;
  }
  /**
   * @param VpnGatewayVpnGatewayInterface[]
   */
  public function setVpnInterfaces($vpnInterfaces)
  {
    $this->vpnInterfaces = $vpnInterfaces;
  }
  /**
   * @return VpnGatewayVpnGatewayInterface[]
   */
  public function getVpnInterfaces()
  {
    return $this->vpnInterfaces;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(VpnGateway::class, 'Google_Service_Compute_VpnGateway');
