<?php
/* 
 * Generated by CRUDigniter v3.2 
 * www.crudigniter.com
 */

use app\libraries\Tenants;

class Rbac_user_role_model extends MY_Model
{
    use Tenants;

    public $table_prefix = 'tbl';
    public $tbl = 'rbac_users_roles';
    public $short = 'ur';

    public function __construct()
    {
        parent::__construct();
    }

    /*
     * Get users_role by id
     */
    function get_users_role($id)
    {
        $this->tenant();

        return $this->db->get_where('rbac_users_roles', array('id' => $id))->row_array();
    }

    /*
     * Get all rbac_users_roles count
     */
    function get_all_rbac_users_roles_count()
    {
        $this->tenant();

        $this->db->from('rbac_users_roles');
        return $this->db->count_all_results();
    }

    /*
     * Get all rbac_users_roles
     */
    function get_all_rbac_users_roles($params = array())
    {
        $this->tenant();

        $this->db->order_by('id', 'desc');
        if (isset($params) && !empty($params)) {
            $this->db->limit($params['limit'], $params['offset']);
        }
        return $this->db->get('rbac_users_roles')->result_array();
    }

    /*
     * function to add new users_role
     */
    function add_users_role($params)
    {
        $this->tenant();

        $this->db->insert('rbac_users_roles', $params);
        return $this->db->insert_id();
    }

    /*
     * function to update users_role
     */
    function update_users_role($id, $params)
    {
        $this->tenant();

        $this->db->where('id', $id);
        return $this->db->update('rbac_users_roles', $params);
    }

    /*
     * function to delete users_role
     */
    function delete_users_role($id)
    {
        $this->tenant();

        return $this->db->delete('rbac_users_roles', array('id' => $id));
    }

    function delete_users_role_by_user($user_id)
    {
        $this->tenant();

        return $this->db->delete('rbac_users_roles', array('user_id' => $user_id));
    }

    function add_users_role_batch($data)
    {
        $this->tenant();

        $this->db->insert_batch('rbac_users_roles', $data);
    }

    function update_users_role_batch($data)
    {
        $this->tenant();

        $this->db->update_batch('rbac_users_roles', $data, 'user_id');
    }

    public function create($params)
    {
        $this->tenant();

        $this->db->insert('rbac_users_roles', $params);

        $params['id'] = $this->db->insert_id();
        return $params;
    }

    public function update($params, $id = null)
    {
        $this->tenant();

        $params['status'] = isset($params['status']) ? $params['status'] : 1;
        $this->db->update('rbac_users_roles', $params, ['id' => $id]);

        $params['id'] = $id;
        return $params;
    }

    public function create_in_employee_tenant($params, $tenantNo)
    {
        // $this->load->model('Employee_model');
        // $employee = $this->Employee_model->detail_username_tenant($params['username'], $tenantNo);
        // $this->tenant_reconnect($tenantNo);
        // $this->create([
        //     'user_id' => $employee['id'],
        //     'role_id' => $params['role_id'],
        // ]);

        // $params['id'] = $this->db->insert_id();

        // $this->tenant_reset();
        // return $params;
    }

    public function create_in_employee_tenant_siteadmin($params)
    {
        // $this->load->model('Tenant_model');
        // $tenants = $this->Tenant_model->listing();
        // foreach ($tenants as $tenant) {
        //     $this->load->model('Employee_model');
        //     $employee = $this->Employee_model->detail_username_tenant($params['username'], $tenant['code']);

        //     $this->tenant_reconnect($tenant['code']);

        //     $this->create([
        //         'user_id' => $employee['id'],
        //         'role_id' => $params['role_id'],
        //     ]);
        // }
        // $this->tenant_reset();
        // return true;
    }

    public function update_in_employee_tenant($params, $tenantNo)
    {
        // $this->load->model('Employee_model');
        // $employee = $this->Employee_model->detail_username_tenant($params['username'], $params['tenant_no']);

        // $this->tenant_reconnect($tenantNo);

        // $this->db->where('user_id', $employee['id'])
        //     ->set('role_id', $params['role_id'])
        //     ->update('rbac_users_roles');

        // $params['id'] = $this->db->insert_id();

        // $this->tenant_reset();
        // return $params;
    }

    public function update_in_employee_tenant_as_non_siteadmin($params, $tenantNo)
    {
        //     $this->load->model('Employee_model');
        //     $this->load->model('Tenant_model');
        //     $tenants = $this->Tenant_model->listing();

        //     foreach ($tenants as $tenant) {
        //         if ($tenant['code'] == $tenantNo) {
        //             continue;
        //         }

        //         $employee = $this->Employee_model->detail_username_tenant($params['username'], $tenantNo);

        //         $this->tenant_reconnect($tenantNo);

        //         $this->db->where('user_id', $employee['id'])->delete('rbac_users_roles');
        //     }

        //     $this->tenant_reset();
        //     return true;
    }

    public function update_in_employee_tenant_as_siteadmin($params)
    {
        // $this->load->model('Tenant_model');

        // $tenants = $this->Tenant_model->listing();

        // foreach ($tenants as $tenant) {
        //     if ($tenant['code'] == $params['tenant_no']) {
        //         continue;
        //     }

        //     $employee = $this->Employee_model->detail_username_tenant($params['username'], $tenant['code']);

        //     $this->tenant_reconnect($tenant['code']);

        //     $this->create([
        //         'user_id' => $employee['id'],
        //         'role_id' => $params['role_id'],
        //     ]);

        //     $this->tenant_reset();
        // }

        // return true;
    }
}
