<?php
/* 
 * Generated by CRUDigniter v3.2 
 * www.crudigniter.com
 */

use app\libraries\CommonHelper;
use app\libraries\DateHelper;
use app\libraries\TenantHelper;
use app\libraries\Tenants;
use app\libraries\Userstamp;

class Rbac_user_model extends MY_TableViewModel
{
    use Tenants;

    public $table_prefix = 'tbl';
    public $tbl = 'rbac_users';
    public $short = 'u';
    public $username_field = 'email';
    public $search_fields = ['display_name', 'email', 'phone'];

    public function __construct()
    {
        parent::__construct();
    }

    public function table_view_get($params = array(), $searchValue, $callback = null)
    {
        $this->table_view_get_criteria($searchValue);

        if (isset($params) && !empty($params)) {
            $this->db->limit($params['limit'], $params['offset'] > 0 ? $params['limit'] * $params['offset'] + 1 : $params['offset']);
        }

        $res = $this->db
            ->join('rbac_roles r', 'ur.role_id = r.id')
            ->select('u.*, , r.name as role, FROM_UNIXTIME(last_login_time) as last_login_time, FROM_UNIXTIME(create_time) as createdate')
            ->order_by('create_time', 'desc')
            ->get()->result_array();

        log_message('debug', $this->db->last_query());
        return $res;
    }

    protected function table_view_get_criteria($searchValue)
    {
        $exclude_roles = $this->_exclude_roles();
        $this->db->from('rbac_users u');
        $this->db->join('rbac_users_roles ur', 'ur.user_id = u.id');
        if (count($exclude_roles) > 0) {
            $this->db->where_not_in('ur.role_id', $exclude_roles);
        }
        $this->db->where_not_in('ur.role_id', [1]);
        $this->db->where('u.deleted_at IS NULL', null, false);

        if (trim($searchValue) && !empty($this->search_fields)) {
            $concatSegment = implode(', " ",', $this->search_fields);
            $concatWhere = sprintf('CONCAT(%s) LIKE ', $concatSegment) . '"%' . $searchValue . '%"';
            $this->db->where($concatWhere, null, false);
        }
    }

    public function validate($params)
    {
        $username = $params['username'];
        $password = $params['password'];

        $username = $this->security->xss_clean($username);
        $password = $this->security->xss_clean($password);
        $encrypted_password = sha1($password);

        $user = $this->getOneRow($this->database, $this->tbl, [], [
            $this->username_field => $username,
            'password' => $encrypted_password,
        ]);

        if (!$user) return false;
        // $this->connectTenantByUsername($result['username']);

        $userInfo = [
            'userid' => $user['id'],
            'firstname' => $user['eng_firstname'],
            'lastname' => $user['eng_lastname'],
            'username' => $user['display_name'],
            $this->username_field => $user[$this->username_field],
            'validated' => true
        ];

        // $this->load->model('System_admin_tenant_model');
        // $this->load->model('System_log_model');
        // $this->load->model('Rbac_user_model');

        $this->systemLog($user['id']);

        $rbacData = $this->rbac($user['id']);

        $landingTenants = [
            // 'tenants' => $this->System_admin_tenant_model->listing_username($username)
        ];

        $this->session->set_userdata($userInfo + $rbacData + $landingTenants);
        return true;
    }

    protected function rbac($userId)
    {
        $userroles = $this->roles($userId);
        $isSuperAdmin = $userroles['rights']['isSuperAdmin'];
        $isAdmin = $userroles['rights']['isAdmin'];
        $isSiteAdmin = $userroles['rights']['isSiteAdmin'];

        $this->load->model("Rbac_role_model");
        $permissions = $this->Rbac_role_model->permissions($userroles['roles']);
        return [
            'roles' => $userroles['roles'],
            'isSuperAdmin' => $isSuperAdmin,
            'isAdmin' => $isAdmin,
            'isSiteAdmin' => $isSiteAdmin,
            'permissions' => $permissions,
        ];
    }

    public function systemLog($userId)
    {
        $this->tenant();

        $this->db
            ->from($this->tbl)
            ->where('id', $userId)
            ->set('last_login_ip', MY_Helper::get_client_ip_env())
            ->set('last_login_time', time())
            ->set('login_count', '`login_count` + 1', false)
            ->update();
    }

    public function roles($user_id)
    {
        $this->tenant();

        $this->load->model('Rbac_role_model');
        $roles = $this->Rbac_role_model->get_user_roles($user_id);
        if (count($roles) > 0) {
            $rights = $this->Rbac_role_model->get_user_rights($roles);
        } else {
            $rights = array(
                'isAdmin' => false,
                'isSuperAdmin' => false,
                'isSiteAdmin' => false
            );
        }

        return array(
            'roles' => $roles,
            'rights' => $rights,
        );
    }
    /*
     * Get user by id
     */
    function get_user($id = null, $where = [])
    {
        $this->tenant();

        if (!empty($id)) $where['id'] = $id;
        return $this->db->get_where($this->tbl, $where)->row_array();
    }

    public function get_user_with_role($id)
    {
        $this->_with_role_criteria();
        return $this->db->where('id', $id)->get()->row_array();
    }

    private function _with_role_criteria()
    {
        $this->load->model('Rbac_user_role_model');
        $this->load->model('Rbac_role_model');



        $exclude_roles = $this->_exclude_roles();
        if (count($exclude_roles) > 0) {
            $this->db->where_not_in('ur.role_id', $exclude_roles);
        }
        $this->db->set_dbprefix('');
        $this->db->from($this->table_prefix . $this->tbl . ' ' . $this->short);
        $this->db->join(
            $this->Rbac_user_role_model->table_prefix . $this->Rbac_user_role_model->tbl . ' ' . $this->Rbac_user_role_model->short,
            $this->Rbac_user_role_model->short . '.user_id = ' . $this->short . '.id'
        );

        $this->db->join(
            $this->Rbac_role_model->table_prefix . $this->Rbac_role_model->tbl . ' ' . $this->Rbac_role_model->short,
            $this->Rbac_user_role_model->short . '.role_id = ' . $this->Rbac_role_model->short . '.id'
        );
        $this->db->select('u.*, u.eng_firstname as firstname, u.eng_lastname as lastname, FROM_UNIXTIME(update_time) as updatedate, FROM_UNIXTIME(create_time) as createdate, r.name', false);
    }

    private function _exclude_roles()
    {
        $this->tenant();

        $this->load->model('Rbac_role_model');
        if ($this->session->userdata('isSiteAdmin')) {
            return [];
        }
        if ($this->session->userdata('isSuperAdmin')) {
            return $this->Rbac_role_model->get_all_site_admin_roles();
        }
        if ($this->session->userdata('isAdmin')) {
            return array_merge($this->Rbac_role_model->get_all_site_admin_roles(), $this->Rbac_role_model->get_all_super_admin_roles());
        }
        return array_merge($this->Rbac_role_model->get_all_site_admin_roles(), $this->Rbac_role_model->get_all_super_admin_roles(), $this->Rbac_role_model->get_all_admin_roles(), [1]);
    }
    /*
     * Get all users count
     */
    function get_all_users_count()
    {
        $this->tenant();

        $exclude_roles = $this->_exclude_roles();
        $this->db->from('rbac_users u');
        $this->db->join('rbac_users_roles ur', 'ur.user_id = u.id');
        if (count($exclude_roles) > 0) {
            $this->db->where_not_in('ur.role_id', $exclude_roles);
        }
        $count = $this->db->count_all_results();
        $this->db->reset_query();
        return $count;
    }

    /*
     * Get all users
     */
    function get_all_users($paging = array(), $where = [])
    {
        $result = $this->get_user_result($paging, $where);
        return $result->result_array();
    }

    /**
     * 
     * @param array $paging
     * @param array $where
     * @return CI_DB_mysql_result
     */
    function get_user_result($paging = array(), $where = [])
    {
        $this->tenant();

        $this->_with_role_criteria();
        if (!empty($where))
            foreach ($where as $field => $condition) {
                $this->db->where($field, $condition);
            }
        // $this->db->order_by('id', 'desc');
        if (isset($paging) && !empty($paging)) {
            $this->db->limit($paging['limit'], $paging['offset'] > 0 ? $paging['limit'] * $paging['offset'] + 1 : $paging['offset']);
        }
        $result = $this->db->get();
        return $result;
    }


    public function add_user($params)
    {
        return $this->insertDB($this->database, $this->tbl, [
            
            'display_name' => $params['display_name'] ?? null,
            'first_name' => $params['first_name'] ?? null,
            'last_name' => $params['last_name'] ?? null,
            $this->Rbac_user_model->username_field => $params[$this->Rbac_user_model->username_field],
            'phone' => $params['phone'],
            'password' => $this->encrypt_password($params['password']),
        ], false);

        // $this->createSystemAdmin($params);
        // $this->createSystemTenant($params);

        // return $this->db->insert_id();
    }

    public function update_user($id, $params)
    {
        unset($params['accept']);
        $updateParams = $params;

        if (!empty($params['display_name'])) $updateParams['display_name'] = $params['display_name'];
        if (!empty($params['first_name'])) $updateParams['first_name'] = $params['first_name'];
        if (!empty($params['last_name'])) $updateParams['last_name'] = $params['last_name'];

        $password = !empty($params['password']) && !empty($params['confirm_password']) && $params['password'] == $params['confirm_password'] ? $params['password'] : '';
        if (!empty($password)) {
            $updateParams['password'] = $this->encrypt_password($password);
        }

        return $this->saveDB($this->database, $this->tbl, $updateParams, $id);

        // $this->db->where('id', $id);

        // Userstamp::$timestamp = true;
        // $res = $this->db->update($this->tbl, Userstamp::update($params, 'updated_by', 'update_time'));

        // $this->updateSystemAdmin($params, $id);

        // return $res;
    }

    /*
     * function to delete user
     */
    function delete_user($id)
    {
        $this->tenant();

        return $this->db->delete($this->tbl, array('id' => $id));
    }

    public function find_or_create($email)
    {
        $this->tenant();

        $data = [
            'first_name' => 'test',
            'last_name' => 'test',
            'email' => $email
        ];

        $query = $this->db->get_where($this->tbl, $data);
        $result = $query->row_array();

        if (!$result) {
            $this->db->insert($this->tbl, $data);
            $this->createSystemAdmin($result);
            $this->createSystemTenant($result);

            return $this->db->insert_id();
        }

        return $result['id'];
    }

    protected function createSystemAdmin($params)
    {
        // $this->load->model('System_admin_model');
        // $this->System_admin_model->create($params);
    }

    protected function updateSystemAdmin($params, $id)
    {
        // $this->load->model('System_admin_model');
        // $this->System_admin_model->update($params, $id);
    }

    /**
     * TODO: setup superadmin
     */
    protected function createSystemTenant($params)
    {
        //     $this->load->model('System_admin_landing_tenant_model');
        //     $this->load->model('System_admin_tenant_model');

        //     $tenantNo = TenantHelper::getTenant();
        //     $_params = [
        //         'username' => $params['username'],
        //         'tenant_no' => $tenantNo
        //     ];

        //     $this->System_admin_landing_tenant_model->create($_params);
        //     $this->System_admin_tenant_model->create($_params);
    }

    /**
     * TODO: setup superadmin
     */
    // protected function updateSystemTenant($params) {
    //     $this->load->model('System_admin_landing_tenant_model');
    //     $this->load->model('System_admin_tenant_model');

    //     $tenantNo = TenantHelper::getTenant();
    //     $_params = [
    //          'username' => $params['username'],
    //          'tenant_no' => $tenantNo
    //     ];

    //     $this->System_admin_landing_tenant_model->create($_params);
    //     $this->System_admin_tenant_model->create($_params);
    // }


    // protected function connectTenantByUsername($username)
    // {
    //     $this->load->model('System_admin_landing_tenant_model');

    //     $res = $this->System_admin_landing_tenant_model->detail($username);
    //     TenantHelper::setTenant($res['tenant_no']);
    // }

    // protected function systemLog($userId)
    // {
    //     $this->System_admin_model->systemLog($userId);
    //     $this->System_log_model->in($userId);
    //     $this->Rbac_user_model->systemLog($userId);
    // }
}
