<?php
/* 
 * Generated by CRUDigniter v3.2 
 * www.crudigniter.com
 */

use app\libraries\Tenants;

class Rbac_role_model extends MY_Model
{
    use Tenants;

    public $table_prefix = 'tbl';
    public $tbl = 'rbac_roles';
    public $short = 'r';

    public function __construct()
    {
        parent::__construct();
    }

    public function get_user_roles($user_id)
    {
        $this->tenant();

        $this->db->select('role_id');
        $this->db->from('rbac_users_roles');
        $this->db->where('user_id', $user_id);
        $result = $this->db->get()->result_array();
        $roles = [];
        foreach ($result as $role) {
            $roles[] = $role['role_id'];
        }
        return $roles;
    }

    public function get_user_rights($roles)
    {
        $this->tenant();

        $isAdmin = false;
        $isSuperAdmin = false;
        $isSiteAdmin = false;
        $this->db->select('tenant, admin, site_admin');
        $this->db->from('rbac_roles');
        //        $this->db->where('tenant', 1);
        //        $this->db->or_where('admin', 1);
        //        $this->db->or_where('site_admin', 1);
        $this->db->where_in('id', $roles);
        $role_types = $this->db->get()->result_array();
        //        print_r($this->db->last_query()); 
        //        print_r ($roles);
        //        print_r ($role_types);
        //        exit;
        foreach ($role_types as $type) {
            if ($type['tenant']) {
                $isSuperAdmin = true;
            }
            if ($type['admin']) {
                $isAdmin = true;
            }
            if ($type['site_admin']) {
                $isSiteAdmin = true;
            }
        }
        return array(
            'isSuperAdmin' => $isSuperAdmin,
            'isAdmin' => $isAdmin,
            'isSiteAdmin' => $isSiteAdmin
        );
    }

    public function permissions($roles)
    {
        $this->tenant();

        $this->load->model('Rbac_permission_model');
        return $this->Rbac_permission_model->get_role_permissions($roles);
    }

    public function get_all_site_admin_roles()
    {
        $this->tenant();

        $this->db->select('id');
        $this->db->where('site_admin', 1);
        $result = $this->db->get('rbac_roles')->result_array();
        $roles = [];
        foreach ($result as $role) {
            $roles[] = $role['id'];
        }
        return $roles;
    }

    public function get_all_super_admin_roles()
    {
        $this->tenant();

        $this->db->select('id');
        $this->db->where(array('tenant' => 1, 'admin' => 1, 'site_admin' => 0));
        $result = $this->db->get('rbac_roles')->result_array();
        $roles = [];
        foreach ($result as $role) {
            $roles[] = $role['id'];
        }
        return $roles;
    }

    public function get_all_admin_roles()
    {
        $this->tenant();

        $this->db->select('id');
        $this->db->where(array('tenant' => 0, 'admin' => 1, 'site_admin' => 0));
        $result = $this->db->get('rbac_roles')->result_array();
        $roles = [];
        foreach ($result as $role) {
            $roles[] = $role['id'];
        }
        return $roles;
    }
    /*
     * Get role by id
     */
    function get_role($id)
    {
        $this->tenant();

        return $this->db->get_where('rbac_roles', array('id' => $id))->row_array();
    }

    private function _exclude_roles()
    {
        $this->tenant();

        if ($this->session->userdata('isSiteAdmin')) {
            return [];
        }
        if ($this->session->userdata('isSuperAdmin')) {
            return $this->get_all_site_admin_roles();
        }
        if ($this->session->userdata('isAdmin')) {
            return array_merge($this->get_all_site_admin_roles(), $this->get_all_super_admin_roles());
        }
        return array_merge($this->get_all_site_admin_roles(), $this->get_all_super_admin_roles(), $this->get_all_admin_roles());
    }
    /*
     * Get all roles count
     */
    function get_all_roles_count()
    {
        $this->tenant();

        $exclude_roles = $this->_exclude_roles();
        $this->db->from('rbac_roles');
        if (count($exclude_roles) > 0) {
            $this->db->where_not_in('id', $exclude_roles);
        }
        return $this->db->count_all_results();
    }

    /*
     * Get all roles
     */
    function get_all_roles($params = array())
    {
        $this->tenant();

        $exclude_roles = $this->_exclude_roles();
        $this->db->order_by('id', 'desc');
        if (isset($params) && !empty($params)) {
            $this->db->limit($params['limit'], $params['offset']);
        }
        if (count($exclude_roles) > 0) {
            $this->db->where_not_in('id', $exclude_roles);
        }
        return $this->db->get('rbac_roles')->result_array();
    }

    /*
     * function to add new role
     */
    function add_role($params)
    {
        $this->tenant();

        $data = [
            'name' => $params['name'],
            'admin' => $params['isAdmin'],
            'tenant' => $params['isTenant'],
            'site_admin' => 0,
        ];
        $this->db->set('createdate', 'NOW()', false);
        $this->db->set('updatedate', 'NOW()', false);
        $this->db->insert('rbac_roles', $data);
        $insert_id = $this->db->insert_id();
        $this->load->model('Rbac_role_permission_model');
        $this->Rbac_role_permission_model->add($params['permissions'] ?? [], $insert_id);
    }

    /*
     * function to update role
     */
    function update_role($params, $id)
    {
        $this->tenant();

        $data = [
            'name' => $params['name'],
            'admin' => $params['isAdmin'],
            'tenant' => $params['isTenant'],
            'status' => $params['status'],
        ];
        $this->db->set('updatedate', 'NOW()', false);
        $this->db->where('id', $id);
        $this->db->update('rbac_roles', $data);
        $this->load->model('Rbac_role_permission_model');
        $this->Rbac_role_permission_model->update($params['permissions'] ?? [], $id);
    }

    /*
     * function to delete role
     */
    function delete_role($id)
    {
        $this->tenant();

        return $this->db->delete('rbac_roles', array('id' => $id));
    }

    public function listing()
    {
        $this->tenant();

        return $this->db->from('rbac_roles')->get()->result_array();
    }

    public function detail_tenant($roleId, $tenantNo)
    {
        // $this->tenant_reconnect($tenantNo);

        // $res = $this->db->from('rbac_roles')->where('id', $roleId)->get()->row_array();

        // $this->tenant_reset();

        // return $res;
    }

    // TODO: fix the accuracy of role_id
    // public function detail_name_tenant($roleName, $tenantNo)
    // {
    //     $this->tenant_reconnect($tenantNo);

    //     $res = $this->db->from('rbac_roles')->where('name', $roleName)->get()->row_array();

    //     $this->tenant_reset();

    //     return $res;
    // }

    public function detail_userId_tenant($userId, $tenantNo)
    {
        // $this->tenant_reconnect($tenantNo);

        // $res = $this->db->from('rbac_roles')
        //     ->join('rbac_users_roles', 'rbac_users_roles.role_id = rbac_roles.id')
        //     ->where('rbac_users_roles.user_id', $userId)->get()->row_array();

        // $this->tenant_reset();

        // return $res;
    }
}
