<?php
/* 
 * Generated by CRUDigniter v3.2 
 * www.crudigniter.com
 */

use app\libraries\FileUpload;
use app\libraries\Tenants;

class Order_maintenance_file_model extends MY_Model
{
    use Tenants;

    public $tbl = 'orders_maintenance_files';

    public function __construct()
    {
        parent::__construct();
    }

    protected function file_upload($path, $base64_image, $filename)
    {
        $fileUpload = new FileUpload();
        $target_path = $fileUpload->get_path($path);
        $fileUpload->make_directory_if_not_exist($target_path);


        $target = $target_path . '/' . $filename;
        $fileUpload->base64_image($base64_image, $target);
        $fileUpload->fix_image_orientation($target);
    }

    public function add_order_maintenance_file($params)
    {
        $path = 'assets/uploads/maintenance_register';
        $display_name = $params['filename'];

        $base64_image = $params['base64_image'];

        $this->file_upload($path, $base64_image, $display_name);
        $_parts = explode('.', $display_name);
        $filename = $this->generate_random_string(8) . '.' . array_pop($_parts);
        move_uploaded_file(FCPATH . $path . '/' . $display_name, FCPATH . $path . '/' . $filename);


        $this->db = $this->load->database($this->database, true);
        return $this->db->insert($this->table_prefix . $this->tbl, [
            'path' => $path,
            'display_name' => $display_name,
            'filename' => $filename,
        ]);
    }

    public function get_order_maintenance_file($order_maintenance_id, $select_fields = [])
    {
        return $this->getOneRow($this->database, $this->tbl, $select_fields, ['order_maintenance_id' => $order_maintenance_id]);
    }

    public function delete_order_maintenance_file($order_maintenance_id)
    {
        $file = $this->get_order_maintenance_file($order_maintenance_id);
        unlink(FCPATH . sprintf("%s/%s", $file['path'], $file['filename']));
        $this->deleteDB($this->database, $this->tbl, $order_maintenance_id, false, 'order_maintenance_id');
    }
}
