<?php

/*
 * Generated by CRUDigniter v3.2 
 * www.crudigniter.com
 */

use app\libraries\FileUpload;
use app\libraries\CSVClass;
use app\libraries\CSVClassImportDataException;
use app\libraries\CSVClassImportErrorItem;
use app\libraries\CSVClassImportErrorItems;
use app\libraries\CsvClassImportResult;

/**
 * @property Promotion_file_model $file
 * @property Promotion_file_model $Promotion_file_model
 */
class Monthly_donation_model extends MY_Model
{
    public $tbl = "tbl_payment_record";
    public $disable_limit_per_page = false;
    public function __construct()
    {
        parent::__construct();
    }


    public function export_members_to_csv()
    {
        $this->disable_limit_per_page = true;
        $res = $this->table_view(0, 0);
        $filename = lang("pages.member.monthly_donation_export.export_csv_filename", ['datetime' => date("YmdHis")]);
        $e = new CSVClass();
        
        array_walk($res['items'],function(&$item){
            if($item['status'] === "0"){
                $item['status'] ="失敗";
            }else if($item['status'] === "1"){
                $item['status'] ="成功";
            }

            if($item['donation_way'] == "0"){
                $item['donation_way'] ="單次捐獻";
            }else if($item['donation_way'] == "1"){
                $item['donation_way'] ="每月捐獻";
            }

            $item['date'] = date("Y-m-d h:i:s",$item['date']);
            
        });

        
        return $e->export(
            [
                'id' => ['omitted' => true],
                'date'=>['value'=>"捐獻日期"],
                'donation_way'=>['value'=>"捐獻類型"],
                'amount'=>['value'=>"捐獻金額"],
                'status'=>['value'=>"狀態"],
                'first_name' => ['value' => lang("pages.member.form.first_name")],
				'last_name' => ['value' => lang("pages.member.form.last_name")],
                'phone' => ['value' => lang("pages.member.form.phone")],
                'email' => ['value' => "登入電郵"],
            ],

            $res['items'],
            $filename
        );
    }

    public function table_view($limit, $per_page, $searchValue = "",$params=array())
    {
        $this->load->library('pagination');
        $this->config->load('pagination');
        $limits = [10, 25, 50, 100];
        // Show per page
        $limit = $limit ?? $limits[0];
        // Page number
        $per_page = $per_page ?? 0;
        $total_rows = $this->table_view_count($searchValue);
        // $this->pagination->initialize($config);

        $users = $this->table_view_get([
            'limit' => $limit,
            'offset' => $per_page
        ], $searchValue,$params);
        
        if ($this->disable_limit_per_page) return [
            'total_rows' => $total_rows,
            'items' => $users
        ];

       

        $config = $this->config->item('pagination');
        $config['base_url'] = base_url('admin_user');
        $config['total_rows'] = $total_rows;
        $this->pagination->initialize($config);


        $cur_page = $per_page + 1;
        $next_page = ($cur_page + 1) * $limit > $total_rows ? $cur_page : $cur_page + 1;
        $max_page = floor($total_rows % $limit > 0 ? $total_rows / $limit + 1 : $total_rows / $limit);

        $prev_page = $cur_page == 1 ? 1 : $cur_page - 1;
        return [
            'total_rows' => $total_rows,
            'limit' => (int) $limit,
            'per_page' => $this->pagination->per_page,
            'per_pages' => $limits,
            'min_limit' => $limits[0],
            'max_limit' => $limits[count($limits) - 1],
            'prev_page' => $prev_page,
            'curr_page' => $cur_page,
            'next_page' => $next_page,
            'max_page' => $max_page,
            'prev_link' => '#',
            'next_link' => '#',
            'items' => $users,
        ];
    }

    private function table_view_get_criteria($searchValue)
    {
       
        $this->db->from($this->table_prefix . $this->tbl);

        if (trim($searchValue)) {
            $performSearchInFields = ['title'];
            
            $concatSegment = implode(', " ",', $performSearchInFields);
            $concatWhere = sprintf('CONCAT(%s) LIKE ', $concatSegment) . '"%' . $searchValue . '%"';
         
            $this->db->where($concatWhere, null, false);
        }

        //$this->db->where('deleted_at IS NULL', null, false);
    }

    /*
     * Get all users
     */
    public function table_view_get($params = array(), $searchValue,$get_params = array())
    {
        
        $this->table_view_get_criteria($searchValue);

        if (isset($params) && !empty($params) && !$this->disable_limit_per_page) {
            $this->db->limit($params['limit'], $params['offset'] > 0 ? $params['limit'] * $params['offset'] : $params['offset']);
        }
        
        if(!empty($get_params)){
            $condition_key = array_keys($get_params)[0];
            $condition_value = array_values($get_params)[0];
            if(array_keys($get_params)[0] == "year"){
                $condition_key  = "DATE_FORMAT(from_unixtime(`date`),'%Y')";
            }else if(array_keys($get_params)[0] == "month"){
                $condition_key  = "DATE_FORMAT(from_unixtime(`date`),'%m')";
            }else if(array_keys($get_params)[0] == "season"){
                $condition_key  = "quarter(DATE_FORMAT(from_unixtime(`date`),'%Y%m%d'))";
            }else if(array_keys($get_params)[0] == "date_range"){
                $date_arr = explode("%7C",$condition_value);
                $start_date = $date_arr[0];
                $end_date = $date_arr[1];
                if(!empty($start_date) && !empty($end_date)){
                    $start_time = strtotime($start_date);
                    $end_date = $end_date." 24:00:00";
                    $end_time = strtotime($end_date);
                    
                    $condition_key = array(
                        "`date` >=",
                        "`date` <="
                    );

                    $condition_value = array(
                        $start_time,
                        $end_time
                    );
                }
            }else if(array_keys($get_params)[0] == "email"){

                if(strpos($condition_value,"%40")!==false){
                    $condition_value = str_replace("%40","@", $condition_value);
                    $this->db->or_like("email",$condition_value);
                    $condition_value = array();
                    $condition_key = array();
                }

            }else if(array_keys($get_params)[0] == "name"){
                
                $this->db->or_like("first_name",$condition_value);
                $this->db->or_like("last_name",$condition_value);
                $condition_value = array();
                $condition_key = array();

               
            }else if(array_keys($get_params)[0] == "phone"){
                $this->db->or_like("phone",$condition_value);
                $condition_value = array();
                $condition_key = array();
            }
            
            if(!empty($condition_key) && !empty($condition_value)){ 
                if(is_array($condition_key)){

                    foreach($condition_key as $k=>$v){
                        $this->db->where($v,$condition_value[$k]);
                    }

                }else{ 

                    $this->db->where($condition_key,$condition_value);
                }
            }
        }
    
        $res = $this->db->select("m.*,tbl_payment_record.*,tbl_payment_record.id as id,(select sum(`amount`) from tbl_payment_record where `status`='1')  as `total_amount`,(select sum(`amount`) from `tbl_payment_record` where donation_way=1 and status=1) as monthly_donation_amount")->join('tblmembers m',"m.id=tbl_payment_record.user_id")
            ->order_by('sort_order', 'asc')
            ->get()->result_array();
        
        //var_dump($this->db->last_query());  exit;
        // log_message('debug', $this->db->last_query());
        return $res;
    }

    /*
     * Get all users count
     */
    public function table_view_count($search)
    {
        $this->table_view_get_criteria($search);
        $count = $this->db->count_all_results();
        $this->db->reset_query();
        return $count;
    }

    protected function file_upload($keyname = "fileToUpload", $path)
    {
        $upload = new FileUpload();
        if ($upload->no_file_uploaded($keyname)) throw new Exception("No file is uploaded");

        $file = $_FILES["fileToUpload"];
        $display_name = $upload->get_upload_filename($file);
        $_parts = explode('.', $display_name);
        $filename = $this->generate_random_string(8) . '.' . array_pop($_parts);

        $uploaded = $upload->upload_image($path, $file, $filename);
        $uploaded['display_name'] = $upload->get_upload_filename($file);
        $uploaded['filename'] = $filename;

        return $uploaded;
    }

    public function add_promotion($params)
    {
        $path = 'assets/uploads/promotions';
        $uploaded = $this->file_upload("fileToUpload", $path);
        if (!$uploaded['success']) {
            throw new Exception($uploaded['message']);
        }
        $id = $this->insertDB($this->database, $this->tbl, [
            'title' => $params['title'],
            'published_at' => $params['published_at'],
            'end_date' => $params['end_date'],
            'content' => $params['content'] ?? null,
        ], false, [
            'updated_at' => date('Y-m-d H:i:s'),
            'updated_by' =>  $this->session->userdata('userid'),
            'created_at' => date('Y-m-d H:i:s'),
            'created_by' =>  $this->session->userdata('userid'),
        ]);

        $this->load->model("Promotion_file_model");
        $this->Promotion_file_model->add_promotion_file([
            "promotion_id" => $id,
            "path" => $path,
            "display_name" => $uploaded["display_name"],
            "filename" => $uploaded["filename"]
        ]);

        return $id;
    }

    /*
     * Get promotion by id
     */

    public function get_donation($id)
    {  
        $this->db->select('*');
        $this->db->from('tbl_payment_record precord');
        $this->db->join('tblmembers m','m.id=precord.user_id');
        $result = $this->db->where("precord.id",$id)->get()->row_array();
        
        return $result;
    }

    public function update_promotion($params, $id)
    {
        try {
            $path = 'assets/uploads/promotions';
            $uploaded = $this->file_upload("fileToUpload", $path);
            if (!$uploaded['success']) {
                throw new Exception($uploaded['message']);
            }
            $this->load->model("Promotion_file_model");
            $this->Promotion_file_model->delete_promotion_file($id);
            $this->Promotion_file_model->add_promotion_file([
                "promotion_id" => $id,
                "path" => $path,
                "display_name" => $uploaded["display_name"],
                "filename" => $uploaded["filename"]
            ]);
        } catch (Exception $ex) {
            if ($ex->getMessage() != "No file is uploaded") throw $ex;
        }

        return $this->saveDB($this->database, $this->tbl, [
            'title' => $params['title'],
            'published_at' => $params['published_at'],
            'end_date' => $params['end_date'],
            'content' => $params['content'],
        ], $id, 'id', [
            'updated_at' => date('Y-m-d H:i:s'),
            'updated_by' =>  $this->session->userdata('userid'),
        ]);
    }

    public function update_display($params)
    {
        return $this->saveDB($this->database, $this->tbl, [
            "display" => $params["display"]
        ], $params["id"], "id", [
            'updated_at' => date('Y-m-d H:i:s'),
            'updated_by' =>  $this->session->userdata('userid'),
        ]);
    }

    public function update_sort_order($params)
    {
        $this->db = $this->load->database($this->database, true);
        $this->db->update_batch($this->table_prefix . $this->tbl, $params, 'id');
    }

    public function get_all_promotion($with_image = false)
    {
        $this->db = $this->load->database($this->database, true);
        $this->db->from($this->table_prefix . $this->tbl);

        $this->db
            ->where('published_at <= NOW()', null, false)
            ->where('end_date > NOW()', null, false)
            ->where('deleted_at IS NULL', null, false);

        if ($with_image) {
            $this->load->model('Promotion_file_model', "file");
            // $this->db->join($this->file->table_prefix . $this->file->tbl . ' '  . $this->file->tbl_short, $this->table_prefix . $this->tbl . '.id = ' . $this->file->tbl_short . '.promotion_id');
            $this->db->join(sprintf("%s %s", $this->file->table_prefix . $this->file->tbl, $this->file->tbl_short), sprintf("%s.id = %s.promotion_id", $this->table_prefix . $this->tbl, $this->file->tbl_short));
            // $this->db->select($this->table_prefix . $this->tbl . '.*, CONCAT("' . base_url() . '", ' . $this->file->tbl_short .  '.path, "/",' . $this->file->tbl_short .  '.filename) AS image_url', false);
            $this->db->select(sprintf("%s.*, CONCAT('%s', %s.path, '/', %s.filename) AS image_url", $this->table_prefix . $this->tbl, base_url(), $this->file->tbl_short, $this->file->tbl_short), false);
        }

        return $this->db
            ->order_by('sort_order', 'asc')
            ->get()->result_array();
    }
}
