<?php

/*
 * Generated by CRUDigniter v3.2 
 * www.crudigniter.com
 */

use app\libraries\Userstamp;

// TODO: Finish the messaging logic.
class Messaging_model extends MY_Model
{
    public $tbl = 'messaging';

    public function table_view($limit, $per_page, $searchValue = "")
    {
        $this->load->library('pagination');
        $this->config->load('pagination');

        $limits = [10, 25, 50, 100];
        // Show per page
        $limit = $limit ?? $limits[0];
        // Page number
        $per_page = $per_page ?? 0;
        $total_rows = $this->table_view_count($searchValue);
        // $this->pagination->initialize($config);

        $users = $this->table_view_get([
            'limit' => $limit,
            'offset' => $per_page
        ], $searchValue);

        $config = $this->config->item('pagination');
        $config['base_url'] = base_url('admin_user');
        $config['total_rows'] = $total_rows;
        $this->pagination->initialize($config);


        $max_page = floor($total_rows % $limit > 0 ? $total_rows / $limit + 1 : $total_rows / $limit);
        $cur_page = $per_page + 1 > $max_page ? $max_page :  $per_page + 1;
        $next_page = ($cur_page + 1) * $limit > $total_rows ? $cur_page : $cur_page + 1;

        $prev_page = $cur_page == 1 ? 1 : $cur_page - 1;
        return [
            'total_rows' => $total_rows,
            'limit' => (int) $limit,
            'per_page' => $this->pagination->per_page,
            'per_pages' => $limits,
            'min_limit' => $limits[0],
            'max_limit' => $limits[count($limits) - 1],
            'prev_page' => $prev_page,
            'curr_page' => $cur_page,
            'next_page' => $next_page,
            'max_page' => $max_page,
            'prev_link' => '#',
            'next_link' => '#',
            'items' => $users,
        ];
    }

    private function table_view_get_criteria($searchValue)
    {
        $this->db->from($this->table_prefix . $this->tbl);

        if (trim($searchValue)) {
            $performSearchInFields = ['title'];

            $concatSegment = implode(', " ",', $performSearchInFields);
            $concatWhere = sprintf('CONCAT(%s) LIKE ', $concatSegment) . '"%' . $searchValue . '%"';
            $this->db->where($concatWhere, null, false);
        }

        $this->db->where('member_ids IS NULL', null, false);
        $this->db->where('deleted_at IS NULL', null, false);
    }

    /*
     * Get all users
     */
    public function table_view_get($params = array(), $searchValue)
    {
        $this->table_view_get_criteria($searchValue);

        if (isset($params) && !empty($params)) {
            $this->db->limit($params['limit'], $params['offset'] > 0 ? $params['limit'] * $params['offset'] : $params['offset']);
        }

        $res = $this->db
            ->order_by('sort_order', 'asc')
            ->get()->result_array();

        // log_message('debug', $this->db->last_query());
        return $res;
    }

    /*
     * Get all users count
     */
    public function table_view_count($search)
    {
        $this->table_view_get_criteria($search);

        $count = $this->db->count_all_results();
        $this->db->reset_query();
        return $count;
    }

    /*
     * Get messaging by id
     */
    public function get_messaging($id)
    {
        return $this->getOne($this->database, $this->tbl, [], $id);
    }

    public function get_all_messaging($member_id = null)
    {
        $this->db = $this->load->database($this->database, true);
        $this->db->from($this->table_prefix . $this->tbl);

        $this->db->group_start();
        if ($member_id) {
            $this->db
                ->or_where("member_ids LIKE '[" . $member_id . ",%'", null, false)
                ->or_where("member_ids LIKE '%," . $member_id . ",%'", null, false)
                ->or_where("member_ids LIKE '%," . $member_id . "]'", null, false);
        }
        $this->db->or_where('member_ids IS NULL', null, false);
        $this->db->group_end();
        return $this->db
            ->where('published_at <= NOW()', null, false)
            ->where('end_date > NOW()', null, false)
            ->where('deleted_at IS NULL', null, false)
            ->order_by('sort_order', 'asc')
            ->get()->result_array();
    }

    public function add_messaging($params)
    {
        $id = $this->insertDB($this->database, $this->tbl, [
            'title' => $params['title'],
            'published_at' => $params['published_at'],
            'end_date' => $params['end_date'],
            'content' => $params['content'],
        ], false, [
            'updated_at' => date('Y-m-d H:i:s'),
            'updated_by' =>  $this->session->userdata('userid'),
            'created_at' => date('Y-m-d H:i:s'),
            'created_by' =>  $this->session->userdata('userid'),
        ]);

        $params['id'] = $id;
        return $params;
    }

    public function update_messaging($params, $id)
    {
        $updateParams = [
            'title' => $params['title'],
            'published_at' => $params['published_at'],
            'end_date' => $params['end_date'],
            'content' => $params['content'],
        ];
        return $this->Messaging_model->saveDB($this->Messaging_model->database, $this->Messaging_model->tbl, $updateParams, $id, 'id', [
            'updated_at' => date('Y-m-d H:i:s'),
            'updated_by' => $this->session->userdata('userid'),
        ]);
    }

    public function update_display($params)
    {
        $res = $this->saveDB($this->database, $this->tbl, [
            "display" => $params["display"]
        ], $params["id"], "id", [
            'updated_at' => date('Y-m-d H:i:s'),
            'updated_by' =>  $this->session->userdata('userid'),
        ]);

        // log_message('debug', $this->db->last_query());
        return $res;
    }

    public function update_sort_order($params)
    {
        $this->db = $this->load->database($this->database, true);
        $res = $this->db->update_batch($this->table_prefix . $this->tbl, $params, 'id');

        // log_message('debug', $this->db->last_query());
        return $res;
    }
}
