<?php

/*
 * Generated by CRUDigniter v3.2 
 * www.crudigniter.com
 */

use app\libraries\FileUpload;


class Course_registration_record_model extends MY_Model
{
    //public $tbl = "promotion";
    public $tbl = "tbl_course_registration_record";
    public function __construct()
    {
        parent::__construct();
    }

    public function table_view($limit, $per_page, $searchValue = "")
    {  

       
        $this->load->library('pagination');
        $this->config->load('pagination');

        $limits = [10, 25, 50, 100];
        // Show per page
        $limit = $limit ?? $limits[0];
        // Page number
        $per_page = $per_page ?? 0;
        $total_rows = $this->table_view_count($searchValue);
        // $this->pagination->initialize($config);
        
        $record = $this->table_view_get([
            'limit' => $limit,
            'offset' => $per_page
        ], $searchValue);
        //var_dump($record); exit;
        $config = $this->config->item('pagination');
        $config['base_url'] = base_url('admin_user');
        $config['total_rows'] = $total_rows;
        $this->pagination->initialize($config);

        
        $cur_page = $per_page + 1;
        $next_page = ($cur_page + 1) * $limit > $total_rows ? $cur_page : $cur_page + 1;
        $max_page = floor($total_rows % $limit > 0 ? $total_rows / $limit + 1 : $total_rows / $limit);

        $prev_page = $cur_page == 1 ? 1 : $cur_page - 1;
        return [
            'total_rows' => $total_rows,
            'limit' => (int) $limit,
            'per_page' => $this->pagination->per_page,
            'per_pages' => $limits,
            'min_limit' => $limits[0],
            'max_limit' => $limits[count($limits) - 1],
            'prev_page' => $prev_page,
            'curr_page' => $cur_page,
            'next_page' => $next_page,
            'max_page' => $max_page,
            'prev_link' => '#',
            'next_link' => '#',
            'items' => $record,
        ];
    }

    private function table_view_get_criteria($searchValue)
    {
        $this->db->from($this->table_prefix . $this->tbl);

        if (trim($searchValue)) {
            $performSearchInFields = ['title'];

            $concatSegment = implode(', " ",', $performSearchInFields);
            $concatWhere = sprintf('CONCAT(%s) LIKE ', $concatSegment) . '"%' . $searchValue . '%"';
            $this->db->where($concatWhere, null, false);
        }

        $this->db->where('deleted_at IS NULL', null, false);
    }

    /*
     * Get all users
     */
    public function table_view_get($params = array(), $searchValue)
    {
        $this->table_view_get_criteria($searchValue);

        if (isset($params) && !empty($params)) {
            $this->db->limit($params['limit'], $params['offset'] > 0 ? $params['limit'] * $params['offset'] : $params['offset']);
        }

        $res = $this->db
            ->order_by('sort_order', 'asc')
            ->get()->result_array();
        
        return $res;
    }

    

    /*
     * Get all users count
     */
    public function table_view_count($search)
    {
        $this->table_view_get_criteria($search);

        $count = $this->db->count_all_results();
        $this->db->reset_query();
        return $count;
    }

    protected function file_upload($keyname = "fileToUpload", $path)
    {
        $upload = new FileUpload();
        if ($upload->no_file_uploaded($keyname)) throw new Exception("No file is uploaded");

        $file = $_FILES["fileToUpload"];
        $display_name = $upload->get_upload_filename($file);
        $_parts = explode('.', $display_name);
        $filename = $this->generate_random_string(8) . '.' . array_pop($_parts);

        $uploaded = $upload->upload_image($path, $file, $filename);
        $uploaded['display_name'] = $upload->get_upload_filename($file);
        $uploaded['filename'] = $filename;

        return $uploaded;
    }

    public function add_task($params)
    {
        $path = 'assets/uploads/promotions';
        $uploaded = $this->file_upload("fileToUpload", $path);
        if (!$uploaded['success']) {
            throw new Exception($uploaded['message']);
        }

        $id = $this->insertDB($this->database, $this->tbl, [
            'task_name' => $params['task_name'],
            'task_content' => $params['task_content'],
            'level' => $params['level'],
            'start_date' => $params['start_date'],
            'end_date' => $params['end_date'],
            'attachment' =>$params['attachment']
            //'created_date' => date("Y-m-d: h:i:s"),
        ], false, [
            
        ]);
        

       //for file upload
        /*
        $this->load->model("Promotion_file_model");
        $this->Promotion_file_model->add_promotion_file([
            "promotion_id" => $id,
            "path" => $path,
            "display_name" => $uploaded["display_name"],
            "filename" => $uploaded["filename"]
        ]);*/

        return $id;
    }

    /*
     * Get promotion by id
     */

    public function get_registration_record($id)
    {
       
        $record = $this->getOne($this->database, $this->tbl, [], $id);
        return $record;
        
        //return $this->getOne($this->database, $this->tbl, [], $id);
    }

    public function delete($ids){
        $result =$this->db->where_in("id",$ids)->delete($this->tbl);
        //echo $this->db->last_query();
        return $result;
    }

    public function update_task($params, $id)
    {
        // try {
        //     $path = 'assets/uploads/promotions';
        //     $uploaded = $this->file_upload("fileToUpload", $path);
        //     if (!$uploaded['success']) {
        //         throw new Exception($uploaded['message']);
        //     }
        //     $this->load->model("Promotion_file_model");
        //     $this->Promotion_file_model->delete_promotion_file($id);
        //     $this->Promotion_file_model->add_promotion_file([
        //         "promotion_id" => $id,
        //         "path" => $path,
        //         "display_name" => $uploaded["display_name"],
        //         "filename" => $uploaded["filename"]
        //     ]);
        // } catch (Exception $ex) {
        //     if ($ex->getMessage() != "No file is uploaded") throw $ex;
        // }

       
        $result = $this->saveDB($this->database, $this->tbl, [
            'task_name' => $params['task_name'],
            'task_content' => $params['task_content'],
            'end_date' => $params['end_date'],
            'start_date' => $params['start_date'],
            'level' => $params['level'],
            'status' => $params['status'],
            'task_members_ids' => $params['task_members_ids'],
        ], $id, 'id', [
            'updated_at' => date('Y-m-d H:i:s'),
            'updated_by' =>  $this->session->userdata('userid'),
        ]);  
          

      
        if(!empty($params['task_members_ids'])){

            $task_members_ids_arr = explode(",",$params['task_members_ids']);
            $this->db->delete('tblmember_task_record', array('task_id' => $id));  
            foreach($task_members_ids_arr as $nember_id){ 
                $data = array(
                        'task_id' => $id,
                        'user_id' => $nember_id,
                        'created_date' => date("Y-m-d h:i:s"),
                );
                
                $insert_task_result = $this->db->replace('tblmember_task_record', $data);
            }

        }else{
            $this->db->delete('tblmember_task_record', array('task_id' => $id));  
        }

        return $result;
    }

    public function update_display($params)
    {
        return $this->saveDB($this->database, $this->tbl, [
            "display" => $params["display"]
        ], $params["id"], "id", [
            'updated_at' => date('Y-m-d H:i:s'),
            'updated_by' =>  $this->session->userdata('userid'),
        ]);
    }

    public function update_sort_order($params)
    {
        $this->db = $this->load->database($this->database, true);
       
        $this->db->update_batch($this->table_prefix . $this->tbl, $params, 'id');
    }

    public function get_all_promotion($with_image = false)
    {
        $this->db = $this->load->database($this->database, true);
        $this->db->from($this->table_prefix . $this->tbl);

        $this->db
            ->where('published_at <= NOW()', null, false)
            ->where('end_date > NOW()', null, false)
            ->where('deleted_at IS NULL', null, false);

        if ($with_image) {
            $this->load->model('Promotion_file_model', "file");
            // $this->db->join($this->file->table_prefix . $this->file->tbl . ' '  . $this->file->tbl_short, $this->table_prefix . $this->tbl . '.id = ' . $this->file->tbl_short . '.promotion_id');
            $this->db->join(sprintf("%s %s", $this->file->table_prefix . $this->file->tbl, $this->file->tbl_short), sprintf("%s.id = %s.promotion_id", $this->table_prefix . $this->tbl, $this->file->tbl_short));
            // $this->db->select($this->table_prefix . $this->tbl . '.*, CONCAT("' . base_url() . '", ' . $this->file->tbl_short .  '.path, "/",' . $this->file->tbl_short .  '.filename) AS image_url', false);
            $this->db->select(sprintf("%s.*, CONCAT('%s', %s.path, '/', %s.filename) AS image_url", $this->table_prefix . $this->tbl, base_url(), $this->file->tbl_short, $this->file->tbl_short), false);
        }

        return $this->db
            ->order_by('sort_order', 'asc')
            ->get()->result_array();
    }
}
